<?php
include "config.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST["username"];
    $password = $_POST["password"];

    if ($username === ADMIN_USER && $password === ADMIN_PASS) {
        $_SESSION["admin"] = $username;
        header("Location: dashboard");
        exit;
    } else {
        $error = "Username atau password salah!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen flex items-center justify-center bg-gray-900">

    <div class="w-full max-w-sm bg-gray-800 rounded-xl shadow-lg p-6">
        <h2 class="text-xl font-bold text-center text-white mb-6">🔑 Login RTP</h2>

        <?php if (!empty($error)): ?>
            <div class="mb-4 p-2 text-sm text-red-700 rounded bg-red-200">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <form method="post" class="space-y-4">
            <!-- Username -->
            <div>
                <input type="text" name="username" placeholder="Username" required
                    class="w-full px-3 py-2 rounded-lg bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:ring-2 focus:ring-blue-500 focus:outline-none">
            </div>

            <!-- Password -->
            <div class="relative">
                <input type="password" id="password" name="password" placeholder="Password" required
                    class="w-full px-3 py-2 rounded-lg bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:ring-2 focus:ring-blue-500 focus:outline-none">
                <button type="button" id="togglePassword"
                    class="absolute inset-y-0 right-3 flex items-center text-gray-400 hover:text-white text-sm">
                    👁️
                </button>
            </div>

            <!-- Button -->
            <button type="submit"
                class="w-full py-2 rounded-lg bg-blue-600 text-white font-semibold hover:bg-blue-500 transition">
                Login
            </button>
        </form>

        <p class="text-center text-gray-400 text-xs mt-6">
            © <?php echo date("Y"); ?> Admin Panel
        </p>
    </div>

    <script>
        const togglePassword = document.getElementById("togglePassword");
        const password = document.getElementById("password");

        togglePassword.addEventListener("click", () => {
            const type = password.getAttribute("type") === "password" ? "text" : "password";
            password.setAttribute("type", type);
            togglePassword.textContent = type === "password" ? "👁️" : "🙈";
        });
    </script>

</body>
</html>
